// check to see if the widget object exists
if (window.widget) {
	window.onfocus = onkeyfocus;
	window.onblur = onkeyrelease;

}

// precache all button images
var btnOnArray = new Array();
btnOnArray["start"] = new Image(57,30);
btnOnArray["stop"] = new Image(57,30);
btnOnArray["reset"] = new Image(57,30);

btnOnArray["start"].src = "images/start_mo.png";
btnOnArray["stop"].src = "images/stop_mo.png";
btnOnArray["reset"].src = "images/reset_mo.png";

var BtnOffArray = new Array();
BtnOffArray["start"] = new Image(57,30);
BtnOffArray["stop"] = new Image(57,30);
BtnOffArray["reset"] = new Image(57,30);

BtnOffArray["start"].src = "images/start.png";
BtnOffArray["stop"].src = "images/stop.png";
BtnOffArray["reset"].src = "images/reset.png";

BGactive = new Image(126,30);
BGactive.src = "images/display_active.png";
BGinactive = new Image(126,30);
BGinactive.src = "images/display_inactive.png";

// initialize timer
var timeIt = new timer();

// main timer function with some methods
function timer() {

	timer.starttime = new Date();
	timer.elapsed = 0;
	timer.running = false;
		
	function display() {
				
		var now = new Date();
		
		timer.elapsed = now.getTime() - timer.starttime;
		minutes = Math.floor( elapsed / 60000);		
		seconds = Math.floor( elapsed / 1000) - minutes * 60;		
		milliseconds = (elapsed % 1000);
		//centiseconds = (elapsed % 1000) - seconds * 1000 - minutes * 60000;
		centiseconds = Math.floor(milliseconds /10);
		
		minprefix = "";
		if (minutes < 10) 
			minprefix = "00";
		else if (minutes < 100)
			minprefix = "0";
		
		centiprefix = "";
		if (centiseconds < 10) 
			centiprefix = "0";
		
	

		
		currenttime = minprefix + minutes + ":" + 
		((seconds < 10) ? "0" : "") + seconds + ":" + centiprefix + centiseconds;
		
		time = document.getElementById("display")
		time.firstChild.data = currenttime;
	}
	
	function start() {
	
		var now = new Date();
		
		// set starttime to current time and add elapsed time if continued
	    if (!timer.starttime) {
			timer.starttime = now.getTime();
		} else {
			timer.starttime = now.getTime() - timer.elapsed;
		}
		timer.running = true;
		// update display every millisecond (or something close to it)
		counter = window.setInterval("timer.display()",60)	
		
		// switch start and stop buttons
		document.getElementById("startbutton").style.display = "";
		document.getElementById("stopbutton").style.display = "block";
	}
	
	function stop() {
	
		// stop updating the display
		window.clearInterval(counter);
	
		timer.running = false;
		timer.display();
		
		// switch start and stop buttons
		document.getElementById("startbutton").style.display = "block";
		document.getElementById("stopbutton").style.display = "";
	}
	
	function reset() {
	
		// depending on state, reset starttime and display or set starttime to current time
	    if (!timer.running) {
			timer.starttime = null;
			time = document.getElementById("display")
			time.firstChild.data = "000:00:00";
		} else {
			var now = new Date();
			timer.starttime = now.getTime();
		}
	}
}

// switch display background if widget is active

function onkeyrelease() {
		document.getElementById("displayBgImg").src = BGinactive.src;
		document.getElementById("display").setAttribute("class", "inactive");
		
}
	
function onkeyfocus() {
		document.getElementById("displayBgImg").src = BGactive.src;
		document.getElementById("display").setAttribute("class", "active");
}

// copy or cut the value of the display.

function cut(event) {
	var display = document.getElementById("display");
	var data = display.firstChild.data;
	
	// cutting resets also the timer back to 00:00:000
	timer.reset();

	event.clipboardData.setData('text/plain', data);
	event.preventDefault();
	event.stopPropagation();
}

function copy(event) {
	var display = document.getElementById("display");
	var data = display.firstChild.data;

	event.clipboardData.setData('text/plain', data);
	event.preventDefault();
	event.stopPropagation();
}

// standart mouse-over button effect

function BtnOn(name) {
	var button = document.getElementById(name);
	button.src = btnOnArray[name].src;
}

function BtnOff(name) {
	var button = document.getElementById(name);
	button.src = BtnOffArray[name].src;
}

// switch between front and back side when user double-clicks on the gadget
// backside just displays the copyright notice

function showFront(event) {
	var front = document.getElementById("front");
	var back = document.getElementById("back");	

	if (window.widget)
		widget.prepareForTransition("ToFront");

	front.style.display = "block";
	back.style.display = "none";

	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
}
	
function showBack(event) {
	var front = document.getElementById("front");
	var back = document.getElementById("back");

	if (window.widget)
		widget.prepareForTransition("ToBack");

	front.style.display = "none";
	back.style.display = "block";

	if (window.widget)
		setTimeout ('widget.performTransition();', 0);	
}